/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;

import proc.text.Codecs;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Utilisateur
 */
public class StatsDatabase {

    private Database theDB;

    public StatsDatabase(Database db) {
        theDB = db;
    }

    public Map<String, String> trouveArticlesParlantDe(String terme) throws NoBaseException {
        Map<String, String> resultat = new HashMap<String, String>();

        String query =
                "SELECT a.titre, f.nom " +
                "FROM rss_articles a, rss_flux f, rss_lemmes l " +
                "WHERE l.lemme='"+Codecs.escapeHTML(terme)+"' AND l.article=a.id AND a.flux=f.id;";
        ResultSet articles = theDB.executeSelection(query);
        
        if (articles != null) {
            try {
                while (articles.next()) { // process results one row at a time

                    String titre = Codecs.desEscapeHTML(articles.getString(1));
                    String flux = Codecs.desEscapeHTML(articles.getString(2));

                    resultat.put(titre, flux);
                }
                articles.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }

        return resultat;
    }
}
